function init(self)
    self.Flags.AlwaysActive = true
end

local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end

function ShakeScreen(self)
	CameraToPoint(GetClaw().X-5+rand()*10,GetClaw().Y-5+rand()*10)
end

function main(self)
    if self.State == 0 then
		self.roof = CreateObject {x=self.X, y=self.Y, z=1000, logic="CustomLogic", name="SunkenColonyRoof", Width=self.Width}
		self.BuildingGrid={}
		self.SunkingTriggerXMin = self.X - 32
		self.SunkingTriggerXMax = self.X + self.Width * 64
		self.SunkingTriggerYMin = self.Y - 128
		
		self.SSSGrid={}
		self.TreasureGrid={}
		self.SSSNumber=0
		for col=1,self.Width,1 do
			self.BuildingGrid[col]={}
			for row=1,self.Height,1 do
				TileNo=664
				if col==1 then
					if row==1 then 
						TileNo=660
					else
						TileNo=663
					end
				elseif col==self.Width then
					if row==1 then 
						TileNo=662
					else
						TileNo=665
					end
				elseif row==1 then
					TileNo=661
				else
					if row~=1 and row%2==1 and col%2==0 and row <= self.Height-2 then
						TileNo=15
						self.SSSNumber = self.SSSNumber + 1
						self.SSSGrid[self.SSSNumber] = CreateObject {x=self.X+(col-1)*64, y=self.Y+(row-1)*64+64, z=1200, logic="CrumblingPegNoRespawn", image="CUSTOM_PEG", SpeedX=128}
						self.SSSGrid[self.SSSNumber].HitRect = {-23,-6,24,8}
						self.SSSGrid[self.SSSNumber].ObjectTypeFlags = 128
						self.TreasureGrid[self.SSSNumber] = GetObject(2608 + self.SSSNumber + (self.Smarts - 1)*12)
						self.TreasureGrid[self.SSSNumber].X = self.X+(col-1)*64
						self.TreasureGrid[self.SSSNumber].Y = self.Y+(row-1)*64
						
					end
				end
				self.BuildingGrid[col][row] = CreateObject {x=self.X+(col-1)*64, y=self.Y+(row-1)*64, z=1000, I=TileNo, logic="CustomLogic", name="SunkenColonyTile", image="ACTION"}
				self.BuildingGrid[col][row]:SetFrame(self.BuildingGrid[col][row].I)
			end
		end
		self.SoundTimer = GetTime() - 3353
		--print(a[3][1])
		self.State = 1
	end
	if self.State == 1 then
		claw = GetClaw()
		if claw.X >= self.SunkingTriggerXMin and claw.X <= self.SunkingTriggerXMax and claw.Y >= self.SunkingTriggerYMin then
			self.State = 2
			self.ShakeStart = GetTime()
		end
	end
	if self.State == 2 then
		ShakeScreen(self)
		if GetTime()-1000 >= self.ShakeStart then
			self.State = 3
			CameraToClaw()
			self.sTime = GetTime()
			self.sY = self.Y
			claw = GetClaw()
			if GetTime() >= self.SoundTimer + 3353 and claw.Y >= 5000 and claw.X <= 32000 then
				PlaySound("CUSTOM_AMBIENT_QUAKE1")
				self.SoundTimer = GetTime()
			end
		end
	end
	if self.State == 3 and claw.Y >= 5000 and claw.X <= 32000 and claw.X >= 29000 then
		--self.mClawY = math.floor( ( self.sTime-GetTime() ) / 1250 )
		self.targetY = self.sY + math.floor((GetTime()-self.sTime) / 19 )
		--TextOut(self.targetY)
		self.mClawY = self.targetY --+ self.Y
		--self.mClawY = 0
		if self.Y <= 6600 then
			self.MoveClawY = self.mClawY - self.Y
			--TextOut(self.MoveClawY)
			self.Y = self.Y + self.MoveClawY
			
			for col=1,self.Width,1 do
				for row=1,self.Height,1 do
					self.BuildingGrid[col][row].Y = self.BuildingGrid[col][row].Y + self.MoveClawY
				end
			end
			for i=1,self.SSSNumber,1 do
				self.SSSGrid[i].MoveClawY = self.MoveClawY
				self.SSSGrid[i].Y = self.SSSGrid[i].Y + self.MoveClawY
				self.TreasureGrid[i].Y = self.TreasureGrid[i].Y + self.MoveClawY
			end
			self.roof.MoveClawY = self.MoveClawY
			self.roof.Y = self.roof.Y + self.MoveClawY
			if GetTime() >= self.SoundTimer + 3353 and claw.Y >= 5000 and claw.X <= 32000 then
				PlaySound("CUSTOM_AMBIENT_QUAKE1")
				self.SoundTimer = GetTime()
			end
		else
			self.State = 4
		end
		--self.sTime = GetTime()
		--TextOut(self.Y)
	end
end